/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;

public abstract class MessageDigest {
    private static boolean debug;
    private byte[] digestBits;
    private String algorithm;

    protected MessageDigest(String string) {
        this.algorithm = string;
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        try {
            return (MessageDigest)Security.getImpl(string, "MessageDigest", null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError("please send a bug report to java-security@java.sun.com");
        }
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return (MessageDigest)Security.getImpl(string, "MessageDigest", string2);
    }

    public void update(byte by) {
        this.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.engineUpdate(byArray, n, n2);
    }

    public void update(byte[] byArray) {
        this.engineUpdate(byArray, 0, byArray.length);
    }

    public byte[] digest() {
        this.digestBits = this.engineDigest();
        return this.digestBits;
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    private static void hexDigit(PrintStream printStream, byte by) {
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        printStream.write(c);
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        printStream.write(c);
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.print(String.valueOf(this.getClass().getName()) + " Message Digest ");
        if (this.digestBits != null) {
            printStream.print("<");
            int n = 0;
            while (n < this.digestBits.length) {
                MessageDigest.hexDigit(printStream, this.digestBits[n]);
                ++n;
            }
            printStream.print(">");
        } else {
            printStream.print("<incomplete>");
        }
        printStream.println();
        return byteArrayOutputStream.toString();
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void reset() {
        this.engineReset();
        this.digestBits = null;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    protected abstract void engineUpdate(byte var1);

    protected abstract void engineUpdate(byte[] var1, int var2, int var3);

    protected abstract byte[] engineDigest();

    protected abstract void engineReset();

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    private void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }
}

